<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiagnosisFormField extends Model
{
  protected $table = 'diagnosis_form_field';
  protected $fillable = [
    'designation_id',
    'name',
    'label',
    'type',
    'options',
    'is_required',
    'group',
    'order',
  ];

  protected $casts = [
    'options' => 'array',
    'is_required' => 'boolean',
  ];

  public function designation()
  {
    return $this->belongsTo(Designation::class);
  }

  public function values()
  {
    return $this->hasMany(DiagnosisFormValue::class, 'field_id');
  }
}
