<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Consultation extends Model
{
  protected $table = 'consultation';
  protected $fillable = [
    'booking_id',
    'consultation_date',
    'consultation_time',
    'additional_observations',
    'behavioural_observations',
    'emotional_observations',
    'cognitive_observations',
    'examination',
    'plan',
    'next_appointment_date',
  ];

  public function booking()
  {
    return $this->belongsTo(DoctorBooking::class, 'booking_id');
  }
  public function diagnosisSubmission()
  {
    return $this->hasOne(DiagnosisFormSubmission::class, 'booking_id', 'booking_id');
  }
}
