<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserAccountResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray(Request $request): array
  {
    return [
      'id'                     => $this->id,
      'first_name'             => $this->first_name,
      'last_name'              => $this->last_name,
      'national_id'            => $this->national_id,
      'national_id_exp_at'     => $this->national_id_exp_at,
      'country_code'           => $this->country_code,
      'mobile_number'          => $this->mobile_number,
      'emergency_country_code' => $this->emergency_country_code,
      'emergency_mobile_number' => $this->emergency_mobile_number,
      'date_of_birth'          => $this->date_of_birth,
      'gender'                 => $this->gender,
      'avatar_url'             => $this->avatar_url,
      'role_id'                => $this->role_id,
      'status'                 => $this->status,
      'created_at'             => $this->created_at,
      'updated_at'             => $this->updated_at,
    ];
  }
}
