<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DoctorResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray(Request $request): array
  {
    return [
      'id' => $this->id,
      'first_name' => $this->first_name,
      'last_name' => $this->last_name,
      'avatar_url' => $this->avatar_url,
      'status' => $this->status,
      'license_no' => $this->doctor->license_no ?? null,
      'experience' => $this->doctor->experience ?? null,
      'qualification' => $this->doctor->qualification ?? null,
      'medical_school' => $this->doctor->medical_school ?? null,
      'bio' => $this->doctor->bio ?? null,
      'areas_of_expertise' => $this->doctor->areas_of_expertise ?? null,
      'avrg_consultation_time' => $this->doctor->avrg_consultation_time ?? null,
      'avrg_consultation_fee' => $this->doctor->avrg_consultation_fee ?? null,
      'department' => $this->department->name ?? null,
      'department_ar' => $this->department->name_ar ?? null,
      'specialization' => $this->specialization->name ?? null,
      'specialization_ar' => $this->specialization->name_ar ?? null,
      'next_available_slot' => $this->whenLoaded('nextAvailableSlot', function () {
        return [
          'working_day' => $this->nextAvailableSlot->workingDay->working_day ?? null,
          'working_hour' => [
            'start_time' => $this->nextAvailableSlot->workingHour->start_time ?? null,
            'end_time' => $this->nextAvailableSlot->workingHour->end_time ?? null,
          ],
        ];
      }),
    ];
  }
}
