<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DoctorReportResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray($request)
  {
    return [
      'consultation' => [
        'id' => $this->id,
        'consultation_date' => $this->consultation_date,
        'consultation_time' => $this->consultation_time,
        'additional_observations' => $this->additional_observations,
        'behavioural_observations' => $this->behavioural_observations,
        'emotional_observations' => $this->emotional_observations,
        'cognitive_observations' => $this->cognitive_observations,
        'examination' => $this->examination,
        'plan' => $this->plan,
        'next_appointment_date' => $this->next_appointment_date,
      ],
      'diagnosis_values' => $this->diagnosisSubmission?->diagnosisValues->map(function ($value) {
        return [
          'field_id' => $value->field_id,
          'field_name' => $value->field->field_name ?? null,
          'value' => $value->value,
        ];
      })->toArray() ?? [],
    ];
  }
}
