<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray(Request $request): array
  {
    return [

      'id' => $this->id,
      'visit_reason' => $this->visit_reason,
      'symtoms' => $this->symtoms,
      'date' => optional($this->slot->workingDay)->working_day,
      'time' => $this->slot && $this->slot->workingHour
        ? $this->slot->workingHour->start_time . ' - ' . $this->slot->workingHour->end_time
        : null,
      'status' => $this->status,
      'patient' => [
        'id' => optional($this->patient)->id,
        'first_name' => optional($this->patient)->first_name,
        'last_name' => optional($this->patient)->last_name,
        'country_code' => optional($this->patient)->country_code,
        'mobile_number' => optional($this->patient)->mobile_number,
        'avatar_url' => optional($this->patient)->avatar_url,
      ],
      'doctor' => [
        'id' => optional($this->doctor)->user_account_id,
        'license_no' => optional($this->doctor)->license_no,
        'qualification' => optional($this->doctor)->qualification,
        'experience' => optional($this->doctor)->experience,
        'department_id' => optional($this->doctor)->department_id,
        'department_name' => optional($this->doctor->department)->name,
        'department_name_ar' => optional($this->doctor->department)->name_ar,
        'average_rating' => $this->doctor->average_rating,
        'reviews_count' => $this->doctor->reviews_count,
        'contact' => [
          'first_name' => optional($this->doctor->userAccount)->first_name,
          'last_name' => optional($this->doctor->userAccount)->last_name,
          'country_code' => optional($this->doctor->userAccount)->country_code,
          'mobile_number' => optional($this->doctor->userAccount)->mobile_number,
          'email' => optional($this->doctor->userLoginData)->email,
          'avatar_url' => optional($this->doctor->userAccount)->avatar_url,
        ],
      ],
    ];
  }
}
