<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingListResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray(Request $request): array
  {
    return [

      'id' => $this->id,
      'visit_reason' => $this->visit_reason,
      'symtoms' => $this->symtoms,
      'date' => optional($this->slot->workingDay)->working_day,
      'time' => $this->slot && $this->slot->workingHour
        ? $this->slot->workingHour->start_time . ' - ' . $this->slot->workingHour->end_time
        : null,
      'status' => $this->status,
      'patient' => [
        'id' => $this->patient->id,
        'first_name' => $this->patient->first_name,
        'last_name' => $this->patient->last_name,
        'country_code' => $this->patient->country_code,
        'mobile_number' => $this->patient->mobile_number,
        'avatar_url' => $this->patient->avatar_url,
      ],
      'doctor' => [
        'id' => $this->doctor->user_account_id,
        'license_no' => $this->doctor->license_no,
        'qualification' => $this->doctor->qualification,
        'experience' => $this->doctor->experience,
        'department_id' => $this->doctor->department_id,
        'department_name' => optional($this->doctor->department)->name,
        'department_name_ar' => optional($this->doctor->department)->name_ar,
        'average_rating' => $this->doctor->average_rating,
        'reviews_count' => $this->doctor->reviews_count,
        'contact' => [
          'first_name' => optional($this->doctor->userAccount)->first_name,
          'last_name' => optional($this->doctor->userAccount)->last_name,
          'country_code' => optional($this->doctor->userAccount)->country_code,
          'mobile_number' => optional($this->doctor->userAccount)->mobile_number,
          'email' => optional($this->doctor->userLoginData)->email,
          'avatar_url' => optional($this->doctor->userAccount)->avatar_url,
        ],
      ],
    ];
  }
}
