<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AvailableDayListResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @return array<string, mixed>
   */
  public function toArray(Request $request): array
  {
    return [
      'id' => $this->id,
      'doctor_id' => $this->doctor_id,
      'working_day' => $this->working_day,
      'slots' => $this->slots->map(function ($slot) {
        return [
          'id' => $slot->id,
          'date' => $this->working_day,
          'start_time' => optional($slot->workingHour)->start_time,
          'end_time' => optional($slot->workingHour)->end_time,
          'status' => $slot->status,
        ];
      }),
      'created_at' => $this->created_at,
      'updated_at' => $this->created_at,
    ];
  }
}
