<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class localeMiddleware
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle(Request $request, Closure $next): Response
  {
    $lang = $request->query('lang', config('app.locale')); // Default to app locale

    // Allow only defined languages
    $allowedLanguages = ['en', 'ar'];
    if (!in_array($lang, $allowedLanguages)) {
      $lang = config('app.fallback_locale'); // Default fallback
    }

    app()->setLocale($lang);
    return $next($request);
  }
}
