<?php

namespace App\Http\Controllers;

use App\Exceptions\AppException;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;
use Illuminate\Auth\Events\Validated;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Tymon\JWTAuth\Facades\JWTAuth;

class FavouriteDoctorController extends Controller
{
  use ApiResponse;
  public function addFavorite(Request $request, $id)
  {
    try {
      $userToken = JWTAuth::parseToken()->getPayload();
      $patientId = $userToken->get('userAccountId');
      // Corrected the log typo to 'info' and added a semicolon at the end
      Log::info('Adding favorite doctor for patient:', ['patientId' => $patientId, 'sd' => $id]);

      // Validate doctor id
      $validator = Validator::make(['doctor_id' => $id], [
        'doctor_id' => 'required|exists:doctor,user_account_id'
      ]);
      if ($validator->fails()) {
        throw new AppException(__('message.validation_error'), 400, $validator->errors());
      }
      $validated = $validator->validated();


      $exists = DB::table('favourite_doctor')
        ->where('patient_id', $patientId)
        ->where('doctor_id', $id)
        ->exists();

      if ($exists) {
        throw new AppException(__('message.doctor_exist_favourite'), 400);
      }

      DB::table('favourite_doctor')->insert([
        'patient_id' => $patientId,
        'doctor_id' =>  $id,
        'created_at' => now(),
        'updated_at' => now(),
      ]);
      return $this->success(200,  __('message.doctor_added_favourite'), null);
    } catch (AppException $e) {
      return $e->render($request);
    } catch (Exception $e) {
      return $this->error(500, __('message.server_error'), [$e->getMessage()]);
    }
  }

  public function getFavorites()
  {
    $userToken = JWTAuth::parseToken()->getPayload();
    $patientId = $userToken->get('userAccountId');

    $favoriteDoctors = UserAccount::whereIn('id', function ($query) use ($patientId) {
      $query->select('doctor_id')
        ->from('favourite_doctor')
        ->where('patient_id', $patientId);
    })
      ->with([
        'doctor:user_account_id,license_no,qualification,experience,department_id',
        'doctor.userAccount:id,first_name,last_name,country_code,mobile_number',
        'doctor.userLoginData:email',
        'doctor.department:id,department_name,department_name_ar',
      ])
      ->get();

    return $this->success(200,  __('message.success'), $favoriteDoctors);
  }

  public function removeFavorite(Request $request, $id)
  {
    try {
      $userToken = JWTAuth::parseToken()->getPayload();
      $patientId = $userToken->get('userAccountId');

      $validator = Validator::make($request->all(), [
        'doctor_id' => 'required|exists:doctors,id',
      ]);
      if ($validator->fails()) {
        throw new AppException(__('message.validation_error'), 400, $validator->errors());
      }
      $validated = $validator->validated();

      $deleted = DB::table('favourite_doctor')
        ->where('patient_id', $patientId)
        ->where('doctor_id', $request->doctor_id)
        ->delete();

      if ($deleted) {
        return $this->success(200,  __('message.doctor_removed_favourite'));
      } else {
        throw new AppException(__('message.doctor_not_exist_favourite'), 400);
      }
    } catch (AppException $e) {
      return $e->render($request);
    } catch (Exception $e) {
      return $this->error(500, __('message.server_error'), [$e->getMessage()]);
    }
  }
}
