<?php

namespace App\Exceptions;

use Exception;

class AppException extends Exception
{
  protected $statusCode;
  protected $errors;

  public function __construct($message = "An error occurred", $statusCode = 400, $errors = null)
  {
    parent::__construct($message);
    $this->statusCode = $statusCode;
    $this->errors = $errors;
  }

  public function render($request)
  {
    $response = [
      'status' => false,
      'message' => $this->getMessage(),
      'statusCode' => $this->statusCode,

    ];
    if (!empty($this->errors)) {
      $response['errors'] = $this->errors;
    }

    return response()->json($response, $this->statusCode);
  }
}
